/*
  Copyright 2016 The Meson development team

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

/* A very simple Python extension module. */

#include <Python.h>
#include <string.h>

static PyObject* phaserize(PyObject *self, PyObject *args) {
    const char *message;
    int result;

    if(!PyArg_ParseTuple(args, "s", &message))
        return NULL;

    result = strcmp(message, "shoot") ? 0 : 1;
    return PyLong_FromLong(result);
}

static PyMethodDef TachyonMethods[] = {
    {"phaserize",  phaserize, METH_VARARGS,
     "Shoot tachyon cannons."},
    {NULL, NULL, 0, NULL}
};

static struct PyModuleDef tachyonmodule = {
   PyModuleDef_HEAD_INIT,
   MESON_MODULENAME,
   NULL,
   -1,
   TachyonMethods
};

PyMODINIT_FUNC PyInit_tachyon(void) {
    return PyModule_Create(&tachyonmodule);
}
